/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.entity;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.yezon.theabyss.TheabyssModElements;
import net.yezon.theabyss.entity.renderer.PlayerBodyRenderer;
import net.yezon.theabyss.itemgroup.TheAbyssEntityItemGroup;
import net.yezon.theabyss.procedures.PlayerBodyDespawnProcedure;
import net.yezon.theabyss.procedures.PlayerBodyParticlesProcedure;
import net.yezon.theabyss.procedures.ReturnToLifeProcedure;

@TheabyssModElements.ModElement.Tag
public class PlayerBodyEntity
extends TheabyssModElements.ModElement {
    public static EntityType entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.5f, 0.5f).func_206830_a("player_body").setRegistryName("player_body");

    public PlayerBodyEntity(TheabyssModElements instance) {
        super(instance, 428);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new PlayerBodyRenderer.ModelRegisterHandler());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new EntityAttributesRegisterHandler());
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -1, -1, new Item.Properties().func_200916_a(TheAbyssEntityItemGroup.tab)).setRegistryName("player_body_spawn_egg"));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
    }

    public static class CustomEntity
    extends MonsterEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 0;
            this.func_94061_f(true);
            this.func_110163_bv();
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        public boolean func_213397_c(double distanceToClosestPlayer) {
            return false;
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.func_76364_f() instanceof PotionEntity) {
                return false;
            }
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            if (source == DamageSource.field_180137_b) {
                return false;
            }
            if (source.func_94541_c()) {
                return false;
            }
            if (source.func_76355_l().equals("trident")) {
                return false;
            }
            if (source == DamageSource.field_82728_o) {
                return false;
            }
            if (source == DamageSource.field_188407_q) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, @Nullable CompoundNBT tag) {
            ILivingEntityData retval = super.func_213386_a(world, difficulty, reason, livingdata, tag);
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            PlayerBodyDespawnProcedure.executeProcedure(Stream.of(new AbstractMap.SimpleEntry<String, IServerWorld>("world", world), new AbstractMap.SimpleEntry<String, CustomEntity>("entity", entity)).collect(HashMap::new, (_m, _e) -> _m.put(_e.getKey(), _e.getValue()), Map::putAll));
            return retval;
        }

        public void func_70030_z() {
            super.func_70030_z();
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            PlayerBodyParticlesProcedure.executeProcedure(Stream.of(new AbstractMap.SimpleEntry<String, World>("world", this.field_70170_p), new AbstractMap.SimpleEntry<String, Double>("x", x), new AbstractMap.SimpleEntry<String, Double>("y", y), new AbstractMap.SimpleEntry<String, Double>("z", z), new AbstractMap.SimpleEntry<String, CustomEntity>("entity", entity)).collect(HashMap::new, (_m, _e) -> _m.put(_e.getKey(), _e.getValue()), Map::putAll));
        }

        public void func_70100_b_(PlayerEntity sourceentity) {
            super.func_70100_b_(sourceentity);
            CustomEntity entity = this;
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            ReturnToLifeProcedure.executeProcedure(Stream.of(new AbstractMap.SimpleEntry<String, CustomEntity>("entity", entity)).collect(HashMap::new, (_m, _e) -> _m.put(_e.getKey(), _e.getValue()), Map::putAll));
        }

        public void func_70636_d() {
            super.func_70636_d();
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            Random random = this.field_70146_Z;
            CustomEntity entity = this;
            for (int l = 0; l < 4; ++l) {
                double d0 = x + 0.5 + ((double)random.nextFloat() - 0.5) * 0.3000000014901161;
                double d1 = y + 0.7 + ((double)random.nextFloat() - 0.5) * 0.3000000014901161 * 100.0 + 0.5;
                double d2 = z + 0.5 + ((double)random.nextFloat() - 0.5) * 0.3000000014901161;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218417_ae, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    private static class EntityAttributesRegisterHandler {
        private EntityAttributesRegisterHandler() {
        }

        @SubscribeEvent
        public void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
            AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
            ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.0);
            ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 10.0);
            ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
            ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 0.0);
            event.put(entity, ammma.func_233813_a_());
        }
    }
}

