/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.loot.LootTables;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.objects.BossSpawnerBlock;
import shadows.apotheosis.deadly.reload.BossItemManager;

public class BossDungeonFeature
extends Feature<NoFeatureConfig> {
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final BlockState BRICK = Blocks.field_196696_di.func_176223_P();
    private static final BlockState MOSSY_BRICK = Blocks.field_196698_dj.func_176223_P();
    private static final BlockState CRACKED_BRICK = Blocks.field_196700_dk.func_176223_P();
    private static final BlockState[] BRICKS = new BlockState[]{BRICK, MOSSY_BRICK, CRACKED_BRICK};
    public static final BossDungeonFeature INSTANCE = new BossDungeonFeature();

    public BossDungeonFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean place(ISeedReader world, ChunkGenerator gen, Random rand, BlockPos pos, NoFeatureConfig cfg) {
        BlockState state;
        BlockPos blockpos;
        int z;
        int y;
        int x;
        if (!DeadlyConfig.canGenerateIn(world)) {
            return false;
        }
        int xRadius = 3 + rand.nextInt(3);
        int floor = -1;
        int roof = 4;
        int zRadius = 3 + rand.nextInt(3);
        int doors = 0;
        BlockState[][][] states = new BlockState[xRadius * 2 + 1][6][zRadius * 2 + 1];
        for (x = -xRadius; x <= xRadius; ++x) {
            for (y = floor; y <= roof; ++y) {
                for (z = -zRadius; z <= zRadius; ++z) {
                    blockpos = pos.func_177982_a(x, y, z);
                    state = world.func_180495_p(blockpos);
                    Material material = state.func_185904_a();
                    boolean flag = material.func_76220_a();
                    if (y == floor && !flag) {
                        return false;
                    }
                    if (y == roof && !flag) {
                        return false;
                    }
                    if ((x == -xRadius || x == xRadius || z == -zRadius || z == zRadius) && y == 1 && state.func_196958_f() && states[x + xRadius][y - 1 + 1][z + zRadius].func_196958_f()) {
                        ++doors;
                    }
                    states[x + xRadius][y + 1][z + zRadius] = state;
                }
            }
        }
        if (doors >= 1 && doors <= 5) {
            for (x = -xRadius; x <= xRadius; ++x) {
                for (y = roof - 1; y >= floor; --y) {
                    for (z = -zRadius; z <= zRadius; ++z) {
                        blockpos = pos.func_177982_a(x, y, z);
                        state = states[x + xRadius][y + 1][z + zRadius];
                        if (x != -xRadius && y != floor && z != -zRadius && x != xRadius && y != roof && z != zRadius) {
                            if (state.func_203425_a(Blocks.field_150486_ae)) continue;
                            world.func_180501_a(blockpos, CAVE_AIR, 2);
                            continue;
                        }
                        if (y > floor && !states[x + xRadius][y - 1 + 1][z + zRadius].func_185904_a().func_76220_a()) {
                            world.func_180501_a(blockpos, CAVE_AIR, 2);
                            continue;
                        }
                        if (!state.func_185904_a().func_76220_a() || state.func_203425_a(Blocks.field_150486_ae)) continue;
                        if (y == floor) {
                            world.func_180501_a(blockpos, BRICKS[rand.nextInt(3)], 2);
                            continue;
                        }
                        world.func_180501_a(blockpos, rand.nextBoolean() ? BRICK : BRICKS[rand.nextInt(3)], 2);
                    }
                }
            }
            int xChestRadius = xRadius - 1;
            int zChestRadius = zRadius - 1;
            block6: for (int chests = 0; chests < 2; ++chests) {
                for (int attempts = 0; attempts < 3; ++attempts) {
                    boolean wall = rand.nextBoolean();
                    int x2 = wall ? (rand.nextBoolean() ? -xChestRadius : xChestRadius) : rand.nextInt(xChestRadius * 2 + 1) - xChestRadius;
                    int y2 = 0;
                    int z2 = !wall ? (rand.nextBoolean() ? -zChestRadius : zChestRadius) : rand.nextInt(zChestRadius * 2 + 1) - zChestRadius;
                    BlockPos blockpos2 = pos.func_177982_a(x2, y2, z2);
                    if (!world.func_180495_p(blockpos2).func_196958_f()) continue;
                    int nearbySolids = 0;
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        if (!world.func_180495_p(blockpos2.func_177972_a(dir)).func_185904_a().func_76220_a()) continue;
                        ++nearbySolids;
                    }
                    if (nearbySolids != true) continue;
                    world.func_180501_a(blockpos2, StructurePiece.func_197528_a((IBlockReader)world, (BlockPos)blockpos2, (BlockState)Blocks.field_150486_ae.func_176223_P()), 2);
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)blockpos2, (ResourceLocation)LootTables.field_186422_d);
                    continue block6;
                }
            }
            world.func_180501_a(pos, ApotheosisObjects.BOSS_SPAWNER.func_176223_P(), 2);
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof BossSpawnerBlock.BossSpawnerTile) {
                ((BossSpawnerBlock.BossSpawnerTile)tileentity).setBossItem(BossItemManager.INSTANCE.getRandomItem(rand));
            } else {
                DeadlyModule.LOGGER.error("Failed to fetch boss spawner entity at ({}, {}, {})", (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
            }
            DeadlyModule.debugLog(pos, "Boss Dungeon");
            return true;
        }
        return false;
    }
}

