/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.library;

import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.library.EnchLibraryTile;
import shadows.placebo.net.MessageButtonClick;

public class EnchLibraryContainer
extends Container
implements MessageButtonClick.IButtonContainer {
    protected World world;
    protected BlockPos pos;
    protected EnchLibraryTile tile = null;
    protected Inventory ioInv = new Inventory(2);
    protected Runnable notifier = null;

    public EnchLibraryContainer(int id, PlayerInventory inv, World world, BlockPos pos) {
        super(ApotheosisObjects.ENCH_LIB_CON, id);
        this.world = world;
        this.pos = pos;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof EnchLibraryTile) {
            this.tile = (EnchLibraryTile)te;
        }
        if (world.field_72995_K) {
            this.tile.addListener(this);
        }
        this.initCommon(inv);
    }

    public EnchLibraryContainer(int id, PlayerInventory inv, BlockPos pos) {
        this(id, inv, (World)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().field_71441_e), pos);
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (!this.world.field_72995_K) {
            this.tile.removeListener(this);
        }
        this.func_193327_a(player, this.world, (IInventory)this.ioInv);
    }

    void initCommon(final PlayerInventory inv) {
        this.func_75146_a(new Slot((IInventory)this.ioInv, 0, 148, 47){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() == Items.field_151134_bR;
            }

            public int func_75219_a() {
                return 1;
            }

            public void func_75218_e() {
                super.func_75218_e();
                if (!EnchLibraryContainer.this.world.field_72995_K && !this.func_75211_c().func_190926_b()) {
                    EnchLibraryContainer.this.tile.depositBook(this.func_75211_c());
                }
                if (!this.func_75211_c().func_190926_b() && EnchLibraryContainer.this.world.field_72995_K) {
                    inv.field_70458_d.field_70170_p.func_184133_a(inv.field_70458_d, EnchLibraryContainer.this.pos, SoundEvents.field_190021_aL, SoundCategory.NEUTRAL, 0.5f, 0.7f);
                }
                EnchLibraryContainer.this.ioInv.func_70299_a(0, ItemStack.field_190927_a);
            }
        });
        this.func_75146_a(new Slot((IInventory)this.ioInv, 1, 148, 98){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() == Items.field_151134_bR;
            }

            public int func_75219_a() {
                return 1;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inv, j + i * 9 + 9, 8 + j * 18, 159 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)inv, k, 8 + k * 18, 217));
        }
    }

    public boolean func_75145_c(PlayerEntity player) {
        return player.func_70092_e((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p()) < 256.0 && this.tile != null && !this.tile.func_145837_r();
    }

    public int getNumStoredEnchants() {
        return (int)this.tile.getPointsMap().values().stream().filter(s -> s > 0).count();
    }

    public List<Object2ShortMap.Entry<Enchantment>> getPointsForDisplay() {
        return this.tile.getPointsMap().object2ShortEntrySet().stream().filter(s -> s.getShortValue() > 0).collect(Collectors.toList());
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 1) {
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (itemstack1.func_77973_b() == Items.field_196128_bn) {
                if (!this.func_75135_a(itemstack1, 1, 2, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (((Slot)this.field_75151_b.get(0)).func_75216_d() || !((Slot)this.field_75151_b.get(0)).func_75214_a(itemstack1)) {
                    return ItemStack.field_190927_a;
                }
                ItemStack itemstack2 = itemstack1.func_77946_l();
                itemstack2.func_190920_e(1);
                itemstack1.func_190918_g(1);
                ((Slot)this.field_75151_b.get(0)).func_75215_d(itemstack2);
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }

    public void setNotifier(Runnable r) {
        this.notifier = r;
    }

    public void onChanged() {
        if (this.notifier != null) {
            this.notifier.run();
        }
    }

    public void onButtonClick(int id) {
        int desired;
        boolean shift;
        boolean bl = shift = (id & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        if (shift) {
            id &= Integer.MAX_VALUE;
        }
        Enchantment ench = (Enchantment)((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(id);
        ItemStack outSlot = this.ioInv.func_70301_a(1);
        int curLvl = EnchantmentHelper.func_82781_a((ItemStack)outSlot).getOrDefault(ench, 0);
        int n = desired = shift ? (int)this.tile.getMax(ench) : curLvl + 1;
        if (!this.tile.canExtract(ench, desired, curLvl)) {
            return;
        }
        if (outSlot.func_190926_b()) {
            outSlot = new ItemStack((IItemProvider)Items.field_151134_bR);
        }
        this.tile.extractEnchant(outSlot, ench, desired);
        this.ioInv.func_70299_a(1, outSlot);
    }
}

