/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.garden;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.garden.ApothBambooBlock;
import shadows.apotheosis.garden.ApothCactusBlock;
import shadows.apotheosis.garden.ApothSugarcaneBlock;
import shadows.apotheosis.garden.EnderLeashItem;
import shadows.placebo.config.Configuration;
import shadows.placebo.util.PlaceboUtil;

public class GardenModule {
    public static int maxCactusHeight = 5;
    public static int maxReedHeight = 255;
    public static int maxBambooHeight = 32;

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        this.reload(null);
        Apotheosis.HELPER.addShapeless((Object)ApotheosisObjects.FARMERS_LEASH, new Object[]{Items.field_151079_bi, Items.field_151058_ca, Items.field_151043_k});
        MinecraftForge.EVENT_BUS.addListener(this::reload);
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        PlaceboUtil.registerOverride((Block)new ApothCactusBlock(), (String)"apotheosis");
        PlaceboUtil.registerOverride((Block)new ApothSugarcaneBlock(), (String)"apotheosis");
        PlaceboUtil.registerOverride((Block)new ApothBambooBlock(), (String)"apotheosis");
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().register(new EnderLeashItem().setRegistryName("farmers_leash"));
        ComposterBlock.field_220299_b.put((Object)Blocks.field_150434_aF.func_199767_j(), 0.5f);
        ComposterBlock.field_220299_b.put((Object)Blocks.field_196608_cF.func_199767_j(), 0.5f);
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        Configuration c = new Configuration(new File(Apotheosis.configDir, "garden.cfg"));
        maxCactusHeight = c.getInt("Cactus Height", "general", maxCactusHeight, 1, 255, "The max height a stack of cacti may grow to.  Vanilla is 3.");
        maxReedHeight = c.getInt("Reed Height", "general", maxReedHeight, 1, 255, "The max height a stack of reeds may grow to.  Vanilla is 3.");
        maxBambooHeight = c.getInt("Bamboo Height", "general", maxBambooHeight, 1, 255, "The max height a stack of bamboo may grow to.  Vanilla is 16.");
        if (e == null && c.hasChanged()) {
            c.save();
        }
    }
}

