/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn.modifiers;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.LazyValue;
import shadows.apotheosis.spawn.SpawnerModifiers;
import shadows.apotheosis.spawn.spawner.ApothSpawnerTile;
import shadows.placebo.config.Configuration;

public abstract class SpawnerModifier {
    public static final String ITEM = "item";
    public static final String VALUE = "value";
    public static final String MIN = "min_value";
    public static final String MAX = "max_value";
    protected LazyValue<Ingredient> item;
    protected int value;
    protected int min;
    protected int max;

    public SpawnerModifier(int value, int min, int max) {
        this.value = value;
        this.min = min;
        this.max = max;
    }

    public SpawnerModifier() {
        this(-1, -1, -1);
    }

    public boolean canModify(ApothSpawnerTile spawner, ItemStack stack, boolean inverting) {
        return ((Ingredient)this.item.func_179281_c()).test(stack);
    }

    public abstract boolean modify(ApothSpawnerTile var1, ItemStack var2, boolean var3);

    public void load(Configuration cfg) {
        String s = cfg.getString(ITEM, this.getId(), this.getDefaultItem(), "The item that applies this modifier.");
        this.item = SpawnerModifiers.readIngredient(s);
        if (this.value != -1) {
            this.value = cfg.getInt(VALUE, this.getId(), this.value, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount each item changes this stat.");
        }
        if (this.min != -1) {
            this.min = cfg.getInt(MIN, this.getId(), this.min, Integer.MIN_VALUE, Integer.MAX_VALUE, "The min value of this stat.");
        }
        if (this.max != -1) {
            this.max = cfg.getInt(MAX, this.getId(), this.max, Integer.MIN_VALUE, Integer.MAX_VALUE, "The max value of this stat.");
        }
    }

    public Ingredient getIngredient() {
        return (Ingredient)this.item.func_179281_c();
    }

    public int getValue() {
        return this.value;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public abstract String getId();

    public abstract String getDefaultItem();

    public void sync(Ingredient ing, int value, int min, int max) {
        this.item = new LazyValue(() -> ing);
        this.item.func_179281_c();
        this.value = value;
        this.min = min;
        this.max = max;
    }
}

