/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Random;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class RandomAttributeModifier {
    protected final Attribute attribute;
    protected final AttributeModifier.Operation op;
    protected final RandomValueRange value;

    public RandomAttributeModifier(Attribute attribute, AttributeModifier.Operation op, RandomValueRange value) {
        this.attribute = attribute;
        this.op = op;
        this.value = value;
    }

    public void apply(Random rand, MobEntity entity) {
        if (entity == null) {
            throw new RuntimeException("Attempted to apply a random attribute modifier to a null entity!");
        }
        AttributeModifier modif = new AttributeModifier("apoth_boss_" + this.attribute.func_233754_c_(), (double)this.value.func_186507_b(rand), this.op);
        ModifiableAttributeInstance inst = entity.func_110148_a(this.attribute);
        if (inst == null) {
            throw new RuntimeException(String.format("Attempted to apply a random attribute modifier to an entity (%s) that does not have that attribute (%s)!", entity.func_200600_R().getRegistryName(), this.attribute.getRegistryName()));
        }
        inst.func_233769_c_(modif);
    }

    public static class Deserializer
    implements JsonDeserializer<RandomAttributeModifier> {
        public RandomAttributeModifier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            String _attribute = obj.get("attribute").getAsString();
            AttributeModifier.Operation op = (AttributeModifier.Operation)ctx.deserialize(obj.get("operation"), AttributeModifier.Operation.class);
            RandomValueRange value = (RandomValueRange)ctx.deserialize(obj.get("value"), RandomValueRange.class);
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(_attribute));
            if (attribute == null || value == null || op == null) {
                throw new JsonParseException("Attempted to deserialize invalid RandomAttributeModifier: " + json.toString());
            }
            return new RandomAttributeModifier(attribute, op, value);
        }
    }
}

