/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mob_grinding_utils.models.ModelTankBlock;
import mob_grinding_utils.tile.TileEntityJumboTank;
import mob_grinding_utils.tile.TileEntitySinkTank;
import mob_grinding_utils.tile.TileEntityTank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityTankRenderer
extends TileEntityRenderer<TileEntityTank> {
    private static final ResourceLocation TANK_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/tank.png");
    private static final ResourceLocation TANK_SINK_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/tank_sink.png");
    private static final ResourceLocation TANK_JUMBO_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/tank_jumbo.png");
    private final ModelTankBlock tank_model = new ModelTankBlock();

    public TileEntityTankRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntityTank tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.5, 0.5);
        matrixStack.func_227862_a_(-0.9999f, -0.9999f, 0.9999f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.tank_model.func_225598_a_(matrixStack, bufferIn.getBuffer(RenderType.func_228646_f_((ResourceLocation)this.getTexture(tile))), combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.func_227865_b_();
        if (tile.tank.getFluid().isEmpty()) {
            return;
        }
        float fluidLevel = tile.tank.getFluidAmount();
        if (fluidLevel < 1.0f) {
            return;
        }
        FluidStack fluidStack = new FluidStack(tile.tank.getFluid(), 100);
        float height = 0.96875f / (float)tile.tank.getCapacity() * (float)tile.tank.getFluidAmount();
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStack.getFluid().getAttributes().getStillTexture());
        IVertexBuilder buffer = bufferIn.getBuffer(RenderType.func_228645_f_());
        int fluidColor = fluidStack.getFluid().getAttributes().getColor();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 0.0);
        float yMin = 0.0f;
        float xMax = 1.984375f;
        float zMax = 1.984375f;
        float xMin = 0.015625f;
        float zMin = 0.015625f;
        yMin = 0.015625f;
        float alpha = 1.0f;
        float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fluidColor & 0xFF) / 255.0f;
        this.renderCuboid(buffer, matrixStack, xMax, xMin, yMin, height, zMin, zMax, fluidStillSprite, red, green, blue, alpha, combinedLight);
        matrixStack.func_227865_b_();
    }

    private ResourceLocation getTexture(TileEntityTank tile) {
        return tile instanceof TileEntityJumboTank ? TANK_JUMBO_TEXTURE : (tile instanceof TileEntitySinkTank ? TANK_SINK_TEXTURE : TANK_TEXTURE);
    }

    private void renderCuboid(IVertexBuilder buffer, MatrixStack matrixStack, float xMax, float xMin, float yMin, float height, float zMin, float zMax, TextureAtlasSprite textureAtlasSprite, float red, float green, float blue, float alpha, int combinedLight) {
        float uMin = textureAtlasSprite.func_94209_e();
        float uMax = textureAtlasSprite.func_94212_f();
        float vMin = textureAtlasSprite.func_94206_g();
        float vMax = textureAtlasSprite.func_94210_h();
        float vHeight = vMax - vMin;
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMin, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMax, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMin, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMax, vMax, red, green, blue, alpha, combinedLight);
    }

    private void addVertexWithUV(IVertexBuilder buffer, MatrixStack matrixStack, float x, float y, float z, float u, float v, float red, float green, float blue, float alpha, int combinedLight) {
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), x / 2.0f, y, z / 2.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_225587_b_(combinedLight, 240).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
    }
}

