/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.inventory.server.ContainerXPSolidifier;
import mob_grinding_utils.recipe.SolidifyRecipe;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityXPSolidifier
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public FluidTank tank = new FluidTank(16000);
    private final LazyOptional<IFluidHandler> tank_holder = LazyOptional.of(() -> this.tank);
    private int prevFluidLevel = 0;
    public int moulding_progress = 0;
    public int MAX_MOULDING_TIME = 100;
    public boolean isOn = false;
    private SolidifyRecipe currentRecipe = null;
    public ItemStackHandler inputSlots = new ItemStackHandler(2);
    public ItemStackHandler outputSlot = new ItemStackHandler(1);
    private final LazyOptional<IItemHandler> outputCap = LazyOptional.of(() -> this.outputSlot);
    public boolean active;
    public int animationTicks;
    public int prevAnimationTicks;
    public OutputDirection outputDirection = OutputDirection.NONE;

    public TileEntityXPSolidifier() {
        super(ModBlocks.XPSOLIDIFIER.getTileEntityType());
    }

    public OutputDirection toggleOutput() {
        switch (this.outputDirection) {
            case WEST: {
                this.outputDirection = OutputDirection.NONE;
                break;
            }
            case SOUTH: {
                this.outputDirection = OutputDirection.WEST;
                break;
            }
            case EAST: {
                this.outputDirection = OutputDirection.SOUTH;
                break;
            }
            case NORTH: {
                this.outputDirection = OutputDirection.EAST;
                break;
            }
            case NONE: {
                this.outputDirection = OutputDirection.NORTH;
            }
        }
        this.func_70296_d();
        return this.outputDirection;
    }

    public void toggleOnOff() {
        this.isOn = !this.isOn;
    }

    public void func_73660_a() {
        if (this.isOn) {
            if (this.func_145831_w().field_72995_K && this.active) {
                this.prevAnimationTicks = this.animationTicks;
                if (this.animationTicks < this.MAX_MOULDING_TIME) {
                    this.animationTicks += 1 + this.getModifierAmount();
                }
                if (this.animationTicks >= this.MAX_MOULDING_TIME) {
                    this.animationTicks -= this.MAX_MOULDING_TIME;
                    this.prevAnimationTicks -= this.MAX_MOULDING_TIME;
                }
            }
            if (this.func_145831_w().field_72995_K && !this.active) {
                this.animationTicks = 0;
                this.prevAnimationTicks = 0;
            }
            if (this.currentRecipe != null) {
                if (!this.currentRecipe.matches(this.inputSlots.getStackInSlot(0))) {
                    this.currentRecipe = null;
                }
            } else {
                this.currentRecipe = TileEntityXPSolidifier.getRecipeForMould(this.inputSlots.getStackInSlot(0));
            }
            if (this.hasfluid() && this.canOperate()) {
                this.setActive(true);
                this.setProgress(this.getProgress() + 1 + this.getModifierAmount());
                if (this.getProgress() >= this.MAX_MOULDING_TIME) {
                    this.setActive(false);
                    this.outputSlot.setStackInSlot(0, this.currentRecipe.getResult());
                    this.tank.drain(this.currentRecipe.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                    return;
                }
            } else if (this.getProgress() > 0) {
                this.setProgress(0);
                this.setActive(false);
            }
            if (this.outputDirection != OutputDirection.NONE && this.getOutputFacing() != null) {
                TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(this.getOutputFacing()));
                if (tile != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getOutputFacing().func_176734_d()).isPresent()) {
                    LazyOptional tileOptional = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getOutputFacing().func_176734_d());
                    tileOptional.ifPresent(handler -> {
                        if (!this.outputSlot.getStackInSlot(0).func_190926_b()) {
                            ItemStack stack = this.outputSlot.getStackInSlot(0).func_77946_l();
                            stack.func_190920_e(1);
                            ItemStack stack1 = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true);
                            if (stack1.func_190926_b()) {
                                ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)this.outputSlot.extractItem(0, 1, false), (boolean)false);
                                this.func_70296_d();
                            }
                        }
                    });
                } else if (tile != null && tile instanceof IInventory) {
                    IInventory iinventory = (IInventory)tile;
                    if (this.isInventoryFull(iinventory, this.getOutputFacing())) {
                        return;
                    }
                    if (!this.outputSlot.getStackInSlot(0).func_190926_b()) {
                        ItemStack stack = this.outputSlot.getStackInSlot(0).func_77946_l();
                        ItemStack stack1 = TileEntityXPSolidifier.putStackInInventoryAllSlots(iinventory, this.outputSlot.extractItem(0, 1, false), this.getOutputFacing().func_176734_d());
                        if (stack1.func_190926_b() || stack1.func_190916_E() == 0) {
                            iinventory.func_70296_d();
                        } else {
                            this.outputSlot.setStackInSlot(0, stack);
                        }
                    }
                }
            }
        } else {
            if (this.func_145831_w().field_72995_K) {
                this.animationTicks = 0;
                this.prevAnimationTicks = 0;
            }
            if (this.getProgress() > 0) {
                this.setActive(false);
                this.setProgress(0);
            }
        }
        if (this.prevFluidLevel != this.tank.getFluidAmount()) {
            this.updateBlock();
            this.prevFluidLevel = this.tank.getFluidAmount();
        }
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    private Direction getOutputFacing() {
        switch (this.outputDirection) {
            case WEST: {
                return Direction.WEST;
            }
            case SOUTH: {
                return Direction.SOUTH;
            }
            case EAST: {
                return Direction.EAST;
            }
            case NORTH: {
                return Direction.NORTH;
            }
            case NONE: {
                break;
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getCachedOutPutRenderStack() {
        if (this.hasMould() && this.inputSlots.getStackInSlot(0).func_77973_b() == ModItems.SOLID_XP_MOULD_BABY.get()) {
            return new ItemStack((IItemProvider)ModItems.SOLID_XP_BABY.get(), 1);
        }
        return ItemStack.field_190927_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressScaled(int count) {
        return this.getProgress() * count / this.MAX_MOULDING_TIME;
    }

    private boolean hasfluid() {
        return this.currentRecipe != null && !this.tank.getFluid().isEmpty() && this.tank.getFluid().getAmount() >= this.currentRecipe.getFluidAmount() && this.tank.getFluidInTank(0).getFluid().func_207185_a(MobGrindingUtils.EXPERIENCE);
    }

    private boolean canOperate() {
        return this.hasMould() && this.isOutputEmpty();
    }

    private boolean hasMould() {
        return this.currentRecipe != null && this.currentRecipe.matches(this.inputSlots.getStackInSlot(0));
    }

    @Nullable
    public static SolidifyRecipe getRecipeForMould(ItemStack stack) {
        return MobGrindingUtils.SOLIDIFIER_RECIPES.stream().filter(recipe -> recipe.matches(stack)).findFirst().orElse(null);
    }

    private boolean isOutputEmpty() {
        return this.outputSlot.getStackInSlot(0).func_190926_b();
    }

    private boolean hasUpgrade() {
        return !this.inputSlots.getStackInSlot(1).func_190926_b() && this.inputSlots.getStackInSlot(1).func_77973_b() == ModItems.XP_SOLIDIFIER_UPGRADE.get();
    }

    public int getModifierAmount() {
        return this.hasUpgrade() ? this.inputSlots.getStackInSlot(1).func_190916_E() : 0;
    }

    private void setProgress(int counter) {
        this.moulding_progress = counter;
    }

    public int getProgress() {
        return this.moulding_progress;
    }

    private boolean isInventoryFull(IInventory inventoryIn, Direction side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int k : aint = isidedinventory.func_180463_a(side)) {
                ItemStack itemstack1 = isidedinventory.func_70301_a(k);
                if (!itemstack1.func_190926_b() && itemstack1.func_190916_E() == itemstack1.func_77976_d()) continue;
                return false;
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventoryIn.func_70301_a(j);
                if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory inventory, ItemStack stack, @Nullable Direction facing) {
        if (inventory instanceof ISidedInventory && facing != null && !(inventory instanceof TileEntityXPSolidifier) && inventory.func_94041_b(0, stack.func_77946_l())) {
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            int[] aint = isidedinventory.func_180463_a(facing);
            for (int k = 0; k < aint.length && !stack.func_190926_b(); ++k) {
                stack = TileEntityXPSolidifier.insertStack(inventory, stack, aint[k], facing);
            }
        } else {
            int i = inventory.func_70302_i_();
            for (int j = 0; j < i && !stack.func_190926_b(); ++j) {
                stack = TileEntityXPSolidifier.insertStack(inventory, stack, j, facing);
            }
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, Direction side) {
        return inventoryIn.func_94041_b(index, stack) && (!(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side));
    }

    private static ItemStack insertStack(IInventory inventory, ItemStack stack, int index, Direction side) {
        ItemStack itemstack = inventory.func_70301_a(index);
        if (TileEntityXPSolidifier.canInsertItemInSlot(inventory, stack, index, side)) {
            if (itemstack.func_190926_b()) {
                inventory.func_70299_a(index, stack);
                stack = ItemStack.field_190927_a;
            } else if (TileEntityXPSolidifier.canCombine(itemstack, stack)) {
                int i = stack.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemstack.func_190917_f(j);
            }
        }
        return stack;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() != stack2.func_77973_b() ? false : (stack1.func_77952_i() != stack2.func_77952_i() ? false : (stack1.func_190916_E() > stack1.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)));
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.tank.readFromNBT(nbt);
        this.inputSlots.deserializeNBT(nbt.func_74775_l("inputSlots"));
        this.outputSlot.deserializeNBT(nbt.func_74775_l("outputSlot"));
        this.outputDirection = OutputDirection.fromString(nbt.func_74779_i("outputDirection"));
        this.isOn = nbt.func_74767_n("isOn");
        this.active = nbt.func_74767_n("active");
        this.moulding_progress = nbt.func_74762_e("moulding_progress");
        if (nbt.func_74764_b("currentRecipe")) {
            ResourceLocation id = new ResourceLocation(nbt.func_74779_i("currentRecipe"));
            MobGrindingUtils.SOLIDIFIER_RECIPES.stream().filter(recipe -> recipe.func_199560_c().equals((Object)id)).findFirst().ifPresent(recipe -> {
                this.currentRecipe = recipe;
            });
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.tank.writeToNBT(nbt);
        nbt.func_218657_a("inputSlots", (INBT)this.inputSlots.serializeNBT());
        nbt.func_218657_a("outputSlot", (INBT)this.outputSlot.serializeNBT());
        nbt.func_74778_a("outputDirection", this.outputDirection.func_176610_l());
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("moulding_progress", this.moulding_progress);
        if (this.currentRecipe != null) {
            nbt.func_74778_a("currentRecipe", this.currentRecipe.func_199560_c().toString());
        }
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        return this.func_189515_b(nbt);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
        this.onContentsChanged();
    }

    public void updateBlock() {
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
    }

    public void onContentsChanged() {
        if (this != null && !this.func_145831_w().field_72995_K) {
            BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 8);
            this.func_70296_d();
        }
    }

    public int getScaledFluid(int scale) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluid().getAmount() / (float)this.tank.getCapacity() * (float)scale) : 0;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("block.mob_grinding_utils.xpsolidifier");
    }

    @Nullable
    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerXPSolidifier(windowID, playerInventory, new PacketBuffer(Unpooled.buffer()).func_179255_a(this.field_174879_c));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tank_holder.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.outputCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public static enum OutputDirection implements IStringSerializable
    {
        NONE("none"),
        NORTH("north"),
        EAST("east"),
        SOUTH("south"),
        WEST("west");

        String name;

        private OutputDirection(String nameIn) {
            this.name = nameIn;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static OutputDirection fromString(String string) {
            for (OutputDirection direction : OutputDirection.values()) {
                if (!direction.name.equals(string)) continue;
                return direction;
            }
            return NONE;
        }
    }
}

