/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.TFSounds;
import twilightforest.block.TFBlocks;
import twilightforest.block.TranslucentBuiltBlock;
import twilightforest.enums.TowerDeviceVariant;
import twilightforest.tileentity.CarminiteBuilderTileEntity;

public class BuilderBlock
extends Block {
    public static final EnumProperty<TowerDeviceVariant> STATE = EnumProperty.func_177709_a((String)"state", TowerDeviceVariant.class);

    public BuilderBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{STATE});
    }

    @Deprecated
    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.field_72995_K && state.func_177229_b(STATE) == TowerDeviceVariant.BUILDER_INACTIVE && world.func_175640_z(pos)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_ACTIVE)));
            world.func_184133_a(null, pos, TFSounds.BUILDER_ON, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (world.field_72995_K) {
            return;
        }
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.func_177229_b(STATE));
        if (variant == TowerDeviceVariant.BUILDER_INACTIVE && world.func_175640_z(pos)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_ACTIVE)));
            world.func_184133_a(null, pos, TFSounds.BUILDER_ON, SoundCategory.BLOCKS, 0.3f, 0.6f);
            world.func_205220_G_().func_205360_a(pos, (Object)this, 4);
        }
        if (variant == TowerDeviceVariant.BUILDER_ACTIVE && !world.func_175640_z(pos)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE)));
            world.func_184133_a(null, pos, TFSounds.BUILDER_OFF, SoundCategory.BLOCKS, 0.3f, 0.6f);
            world.func_205220_G_().func_205360_a(pos, (Object)this, 4);
        }
        if (variant == TowerDeviceVariant.BUILDER_TIMEOUT && !world.func_175640_z(pos)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE)));
        }
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.func_177229_b(STATE));
        if (variant == TowerDeviceVariant.BUILDER_ACTIVE && world.func_175640_z(pos)) {
            this.letsBuild((World)world, pos);
        }
        if (variant == TowerDeviceVariant.BUILDER_INACTIVE || variant == TowerDeviceVariant.BUILDER_TIMEOUT) {
            for (Direction e : Direction.values()) {
                BuilderBlock.activateBuiltBlocks((World)world, pos.func_177972_a(e));
            }
        }
    }

    private void letsBuild(World world, BlockPos pos) {
        CarminiteBuilderTileEntity tileEntity = (CarminiteBuilderTileEntity)world.func_175625_s(pos);
        if (tileEntity != null && !tileEntity.makingBlocks) {
            tileEntity.startBuilding();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (state.func_177229_b(STATE) == TowerDeviceVariant.BUILDER_ACTIVE) {
            this.sparkle(world, pos);
        }
    }

    public void sparkle(World worldIn, BlockPos pos) {
        Random random = worldIn.field_73012_v;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.func_177958_n() + random.nextFloat();
            double d2 = (float)pos.func_177956_o() + random.nextFloat();
            double d3 = (float)pos.func_177952_p() + random.nextFloat();
            if (i == 0 && !worldIn.func_180495_p(pos.func_177984_a()).func_200015_d((IBlockReader)worldIn, pos)) {
                d2 = (double)pos.func_177956_o() + d0 + 1.0;
            }
            if (i == 1 && !worldIn.func_180495_p(pos.func_177977_b()).func_200015_d((IBlockReader)worldIn, pos)) {
                d2 = (double)pos.func_177956_o() - d0;
            }
            if (i == 2 && !worldIn.func_180495_p(pos.func_177968_d()).func_200015_d((IBlockReader)worldIn, pos)) {
                d3 = (double)pos.func_177952_p() + d0 + 1.0;
            }
            if (i == 3 && !worldIn.func_180495_p(pos.func_177978_c()).func_200015_d((IBlockReader)worldIn, pos)) {
                d3 = (double)pos.func_177952_p() - d0;
            }
            if (i == 4 && !worldIn.func_180495_p(pos.func_177974_f()).func_200015_d((IBlockReader)worldIn, pos)) {
                d1 = (double)pos.func_177958_n() + d0 + 1.0;
            }
            if (i == 5 && !worldIn.func_180495_p(pos.func_177976_e()).func_200015_d((IBlockReader)worldIn, pos)) {
                d1 = (double)pos.func_177958_n() - d0;
            }
            float f1 = 1.0f;
            float f2 = Math.max(0.0f, 0.19999999f);
            float f3 = Math.max(0.0f, -0.099999964f);
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
            worldIn.func_195594_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    public static void activateBuiltBlocks(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == TFBlocks.built_block.get() && !((Boolean)state.func_177229_b((Property)TranslucentBuiltBlock.ACTIVE)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)TranslucentBuiltBlock.ACTIVE, (Comparable)Boolean.valueOf(true)));
            world.func_184133_a(null, pos, TFSounds.BUILDER_REPLACE, SoundCategory.BLOCKS, 0.3f, 0.6f);
            world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 15);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return state.func_177229_b(STATE) == TowerDeviceVariant.BUILDER_ACTIVE;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return state.func_177229_b(STATE) == TowerDeviceVariant.BUILDER_ACTIVE ? new CarminiteBuilderTileEntity() : null;
    }
}

