/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.lichtower;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.structures.lichtower.LichTowerPieces;
import twilightforest.structures.lichtower.TowerRoofComponent;
import twilightforest.structures.lichtower.TowerWingComponent;

public class TowerRoofGableForwardsComponent
extends TowerRoofComponent {
    public TowerRoofGableForwardsComponent(TemplateManager manager, CompoundNBT nbt) {
        super(LichTowerPieces.TFLTRGF, nbt);
    }

    public TowerRoofGableForwardsComponent(TFFeature feature, int i, TowerWingComponent wing) {
        super(LichTowerPieces.TFLTRGF, feature, i);
        this.func_186164_a(wing.func_186165_e());
        this.height = this.size = wing.size + 2;
        this.makeAttachedOverhangBB(wing);
    }

    @Override
    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockState birchSlab = Blocks.field_196627_bs.func_176223_P();
        BlockState birchPlanks = Blocks.field_196666_p.func_176223_P();
        int slopeChange = this.slopeChangeForSize();
        for (int y = 0; y <= this.height; ++y) {
            int max;
            int min;
            if (y < slopeChange) {
                min = y;
                max = this.size - y - 1;
            } else {
                min = (y + slopeChange) / 2;
                max = this.size - (y + slopeChange) / 2 - 1;
            }
            for (int x = 0; x <= this.size - 2; ++x) {
                for (int z = min; z <= max; ++z) {
                    if (z == min || z == max) {
                        this.func_175811_a(world, birchPlanks, x, y, z, sbb);
                        continue;
                    }
                    if (x >= this.size - 2) continue;
                    this.func_175811_a(world, birchPlanks, x, y, z, sbb);
                }
            }
        }
        int top = this.size + 1 - slopeChange;
        int zMid = this.size / 2;
        this.func_175811_a(world, (BlockState)birchSlab.func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP), this.size - 1, top - 1, zMid, sbb);
        this.func_175811_a(world, birchSlab, 0, top, zMid, sbb);
        this.func_175811_a(world, birchSlab, this.size - 3, top, zMid, sbb);
        this.func_175811_a(world, birchPlanks, this.size - 2, top, zMid, sbb);
        this.func_175811_a(world, birchPlanks, this.size - 1, top, zMid, sbb);
        this.func_175811_a(world, birchPlanks, this.size - 1, top + 1, zMid, sbb);
        return true;
    }

    public int slopeChangeForSize() {
        if (this.size > 10) {
            return 3;
        }
        if (this.size > 6) {
            return 2;
        }
        return 1;
    }
}

